/* 
 *  SmulateCases.java
 *
 *  Example use of Netica-J for generating random cases that follow
 *  the probability distribution given by a Bayes net.
 */

import java.io.File;
import norsys.netica.*;

public class SimulateCases {

  public static void main(String[] args) {
    int numCases = 200;
    System.out.println( "Creating " + numCases + " random cases..." );

    try {
	Environ env = new Environ (null);

	// Read in the net created by the BuildNet.java example program
	Net        net = new Net (new Streamer ("ChestClinicBuilt.dne"));
	NodeList nodes = net.getNodes();
	
	(new File("ChestClinic.cas")).delete(); // "ChestClinic.cas" may exist from a previous run
	Streamer caseFile = new Streamer ("ChestClinic.cas");

	net.compile();
	
	for (int n=0; n < numCases; n++) {
	    net.retractFindings();
	    int res = net.generateRandomCase (nodes, 0, 20);
	    if (res >= 0) {
		net.writeFindings (caseFile, nodes,  n, -1.0);
	    }
	}

	net.finalize();   // not strictly necessary, but a good habit
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}

