/* 
 *  TestNet.java
 *
 *  Example use of Netica-J for testing the performance of 
 *  a learned net with the net tester tool.
 */

import java.io.File;
import norsys.netica.*;

public class TestNet {

  public static void main(String[] args) {
    System.out.println ("Running Netica-J TestNet example...");

    try {
	Environ env = new Environ (null);

	Net      net         = new Net (new Streamer ("ChestClinic.dne"));
	NodeList testNodes   = new NodeList (net);
	NodeList unobsvNodes = new NodeList (net);

	Node visitAsia    = net.getNode ("VisitAsia");
	Node tuberculosis = net.getNode ("Tuberculosis");
	Node cancer       = net.getNode ("Cancer");
	Node smoking      = net.getNode ("Smoking");
	Node tbOrCa       = net.getNode ("TbOrCa");
	Node xRay         = net.getNode ("XRay");
	Node dyspnea      = net.getNode ("Dyspnea");
	Node bronchitis   = net.getNode ("Bronchitis");
	
	// The observed nodes are typically the factors known during diagnosis
	testNodes.add (visitAsia);
	testNodes.add (smoking);
	testNodes.add (xRay);
	testNodes.add (dyspnea);
	//testNodes.add (bronchitis);

        // The unobserved nodes are typically the factors not known during diagnosis:
	unobsvNodes.add (cancer);
	unobsvNodes.add (tuberculosis);
	unobsvNodes.add (tbOrCa);

	net.retractFindings();  // IMPORTANT: Otherwise any findings will be part of tests !!
	net.compile();

	NetTester tester = new NetTester (testNodes, unobsvNodes, -1);

	Streamer  inStream = new Streamer ("ChestClinic.cas");
	tester.testWithFile (inStream);

	printConfusionMatrix (tester, visitAsia);
	System.out.println ("Error rate for " + visitAsia.getName() + " = " + tester.getErrorRate (visitAsia));
	System.out.println ("Logarithmic loss = " + tester.getLogLoss (visitAsia));

	printConfusionMatrix (tester, smoking);
	System.out.println ("Error rate for " + smoking.getName()   + " = " + tester.getErrorRate (smoking));
	System.out.println ("Logarithmic loss = " + tester.getLogLoss (smoking));

	printConfusionMatrix (tester, xRay);
	System.out.println ("Error rate for " + xRay.getName()      + " = " + tester.getErrorRate (xRay));
	System.out.println ("Logarithmic loss = " + tester.getLogLoss (xRay));
	
	// not strictly necessary, but a good habit
	tester.finalize();
	net.finalize();   
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }

  /*
   * Print a confusion matrix table.
   * This method can be found in examples\TestNet.java
   * that comes with this distribution.
   */
  public static void printConfusionMatrix (NetTester nt, Node node) throws NeticaException {
      int numStates = node.getNumStates();
      System.out.println("\nConfusion matrix for " + node.getName() + ":");
  
      for (int i=0;  i < numStates;  ++i){
          System.out.print ("\t" + node.state(i).getName());
      }
      System.out.println ("\tActual");
  
      for (int a=0;  a < numStates;  ++a){
          for (int p=0;  p < numStates;  ++p){
              System.out.print ("\t" + (int) (nt.getConfusion(node, p, a)));
          }
          System.out.println ("\t" + node.state(a).getName());
      }
  }

}
