/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import norsys.netica.Environ;
import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;
import norsys.netica.Streamer;
import norsys.netica.Util;

public class NetEx
extends Net {
    public NetEx() throws NeticaException {
    }

    public NetEx(Environ environ) throws NeticaException {
        super(environ);
    }

    public NetEx(Streamer streamer) throws NeticaException {
        super(streamer);
    }

    public static Net duplicateNet(Net net, String string) throws NeticaException {
        Net net2 = new Net(net.getEnviron());
        net2.doc().setName(string);
        NodeList nodeList = Net.duplicateNodes(net.getNodes(), net2);
        NodeList nodeList2 = net.getElimOrder();
        NodeList nodeList3 = NodeListEx.mapNodeList(nodeList2, net2);
        net2.setElimOrder(nodeList3);
        net2.setAutoUpdate(net.getAutoUpdate());
        net2.doc().setTitle(net.doc().getTitle());
        net2.doc().setComment(net.doc().getComment());
        net2.doc().setUserData(net.doc().getUserData());
        return net2;
    }

    public void enterFinding(String string, String string2) throws NeticaException {
        Node node = this.getNode(string);
        node.enterFinding(string2);
    }

    public void setUserAsciiString(String string, String string2) throws NeticaException {
        if (!Util.isAscii(string2)) {
            throw new NeticaException(20000, "Not an ascii string");
        }
        this.doc().setUserField(string, (Serializable)((Object)string2));
    }

    public void setUserNumber(String string, double d) throws NeticaException {
        this.doc().setUserField(string, (Serializable)((Object)("" + d)));
    }

    public String getUserAsciiString(String string) throws NeticaException {
        String string2 = (String)this.doc().getUserField(string);
        if (!Util.isAscii(string2)) {
            throw new NeticaException(20000, "Not an ascii string");
        }
        return string2;
    }

    public double getUserNumber(String string) throws Exception {
        String string2 = (String)this.doc().getUserField(string);
        return Double.parseDouble(string2);
    }

    public static Net getNetNamed(String string, Environ environ) throws NeticaException {
        Vector vector = Net.getAllNets(environ);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Net net = (Net)enumeration.nextElement();
            if (!net.doc().getName().equals(string)) continue;
            return net;
        }
        return null;
    }

    public Node getExistingNode(String string) throws NeticaException {
        Node node = this.getNode(string);
        if (node == null) {
            throw new NeticaException(20000, "There is no node named " + string + " in net " + this.doc().getName());
        }
        return node;
    }
}

