/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;
import norsys.netica.Util;

public class NodeEx
extends Node {
    public NodeEx(String string, int n, Net net) throws NeticaException {
        super(string, n, net);
    }

    public NodeEx(String string, String string2, Net net) throws NeticaException {
        super(string, string2, net);
    }

    public NodeEx() {
    }

    public static void absorb(Node node) throws NeticaException {
        Net net = node.getNet();
        NodeList nodeList = new NodeList(1, net);
        nodeList.add(node);
        net.absorb(nodeList);
    }

    public Node duplicate(Net net) throws NeticaException {
        NodeList nodeList = new NodeList(1, this.getNet());
        nodeList.add(this);
        NodeList nodeList2 = Net.duplicateNodes(nodeList, net);
        return (Node)nodeList2.get(0);
    }

    public Node dupNode() throws NeticaException {
        return this.duplicate(this.getNet());
    }

    public void setCPTable(String string, double d, double d2) throws NeticaException {
        float[] fArray = new float[]{(float)d, (float)d2};
        this.setCPTable(string, fArray);
    }

    public void setCPTable(String string, double d, double d2, double d3) throws NeticaException {
        float[] fArray = new float[]{(float)d, (float)d2, (float)d3};
        this.setCPTable(string, fArray);
    }

    public void setCPTable(double d, double d2) throws NeticaException {
        this.setCPTable(null, d, d2);
    }

    public void setCPTable(double d, double d2, double d3) throws NeticaException {
        this.setCPTable(null, d, d2, d3);
    }

    public void setCPTable(String string, String string2, double d, double d2) throws NeticaException {
        float[] fArray = new float[]{(float)d, (float)d2};
        this.setCPTable(string + "," + string2, fArray);
    }

    public float[] getCPTable(int[] nArray) throws NeticaException {
        return this.getCPTable(nArray, null);
    }

    public float[] getCPTable(String string) throws NeticaException {
        return this.getCPTable(string, null);
    }

    public void changeFinding(int n) throws NeticaException {
        int n2 = this.getNet().getAutoUpdate();
        this.getNet().setAutoUpdate(0);
        this.retractFindings();
        this.enterFinding(n);
        this.getNet().setAutoUpdate(n2);
    }

    public void changeFinding(String string) throws NeticaException {
        this.changeFinding(this.getStateIndex(string));
    }

    public void changeValue(double d) throws NeticaException {
        this.getNet().setAutoUpdate(0);
        this.retractFindings();
        this.enterValue(d);
        this.getNet().setAutoUpdate(1);
    }

    public void enterFindingNot(String string) throws NeticaException {
        this.enterFindingNot(this.getStateIndex(string));
    }

    public int getParentIndex(Node node) throws NeticaException {
        NodeList nodeList = this.getParents();
        int n = 0;
        while (n < nodeList.size()) {
            Node node2 = (Node)nodeList.get(n);
            if (node2.equals(node)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getParentIndex(String string) throws NeticaException {
        Node node = this.getNet().getNode(string);
        return this.getParentIndex(node);
    }

    public static void deleteLink(Node node, Node node2) throws NeticaException {
        NodeList nodeList = node2.getParents();
        int n = nodeList.indexOf(node);
        node2.deleteLink(n);
    }

    public void deleteLinks(Node node) throws NeticaException {
        NodeList nodeList = this.getParents();
        int n = 0;
        while (n < nodeList.size()) {
            Node node2 = (Node)nodeList.get(n);
            if (node2.equals(node)) {
                this.deleteLink(n);
            }
            ++n;
        }
    }

    public static void deleteLinksEntering(Node node) throws NeticaException {
        NodeList nodeList = node.getParents();
        int n = nodeList.size();
        int n2 = 0;
        while (n2 < n) {
            node.deleteLink(0);
            ++n2;
        }
    }

    public void switchParent(Node node, Node node2) throws NeticaException {
        int n = this.getParentIndex(node);
        this.switchParent(n, node2);
    }

    public String getStateNames() throws NeticaException {
        String[] stringArray = this.getStateNamesArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.docState(n).getName());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String[] getStateNamesArray() throws NeticaException {
        int n = this.getNumStates();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.docState(n2).getName();
            ++n2;
        }
        return stringArray;
    }

    public void setUserAsciiString(String string, String string2) throws NeticaException {
        if (!Util.isAscii(string2)) {
            throw new NeticaException(20000, "Not an ascii string");
        }
        this.doc().setUserField(string, (Serializable)((Object)string2));
    }

    public void setUserNumber(String string, double d) throws NeticaException {
        this.doc().setUserField(string, (Serializable)((Object)("" + d)));
    }

    public String getUserAsciiString(String string) throws NeticaException {
        String string2 = (String)this.doc().getUserField(string);
        if (!Util.isAscii(string2)) {
            throw new NeticaException(20000, "Not an ascii string");
        }
        return string2;
    }

    public double getUserNumber(String string) throws Exception {
        String string2 = (String)this.doc().getUserField(string);
        return Double.parseDouble(string2);
    }

    public static void makeProbsUniform(Node node) throws NeticaException {
        int n = node.getNumStates();
        int n2 = node.getParents().size();
        float[] fArray = new float[n];
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n) {
            fArray[n3] = 1.0f / (float)n;
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = -5;
            ++n4;
        }
        node.setCPTable(nArray, fArray);
    }

    public static void setNodeAllProbs(Node node, float[][] fArray) throws NeticaException {
        NodeList nodeList = node.getParents();
        int[] nArray = new int[nodeList.size()];
        int n = 0;
        do {
            node.setCPTable(nArray, fArray[n++]);
        } while (!NodeListEx.nextStates(nArray, nodeList));
    }

    public static boolean isLinkDisconnected(int n, Node node) throws NeticaException {
        NodeList nodeList = node.getParents();
        Node node2 = (Node)nodeList.get(n);
        return node2.getKind() == 205;
    }

    public int[] getStateFuncTable(String string, int[] nArray) throws NeticaException {
        return this.getStateFuncTable(this.parentStatesToIndexes(string), nArray);
    }

    public int[] getStateFuncTable(String string) throws NeticaException {
        return this.getStateFuncTable(this.parentStatesToIndexes(string), null);
    }

    public double[] getRealFuncTable(String string, double[] dArray) throws NeticaException {
        return this.getRealFuncTable(this.parentStatesToIndexes(string), dArray);
    }

    public double[] getRealFuncTable(String string) throws NeticaException {
        return this.getRealFuncTable(this.parentStatesToIndexes(string), null);
    }

    public double[] getExperTable(String string, double[] dArray) throws NeticaException {
        return this.getExperTable(this.parentStatesToIndexes(string), dArray);
    }

    public double[] getExperTable(String string) throws NeticaException {
        return this.getExperTable(this.parentStatesToIndexes(string), null);
    }

    public void setStateFuncTable(String string, int n) throws NeticaException {
        this.setStateFuncTable(this.parentStatesToIndexes(string), n);
    }

    public void setRealFuncTable(String string, double d) throws NeticaException {
        this.setRealFuncTable(this.parentStatesToIndexes(string), d);
    }

    public void setExperTable(String string, double d) throws NeticaException {
        this.setExperTable(this.parentStatesToIndexes(string), d);
    }
}

