/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.Node;

public class Doc {
    Object obj;
    int stateIndex = -1;
    private Object userData;
    private static final int NO_TYPE = 0;
    private static final int NET_TYPE = 1;
    private static final int NODE_TYPE = 2;
    private static final int STATE_TYPE = 3;
    private int parentType = 0;

    Doc(Object object, int n) throws NeticaException {
        this(object);
        if (this.parentType != 2) {
            throw new NeticaException("State Documentation is available for Nodes only.");
        }
        this.parentType = 3;
        this.stateIndex = n;
    }

    Doc(Object object) throws NeticaException {
        this.obj = object;
        if (object instanceof Net) {
            this.parentType = 1;
        } else if (object instanceof Node) {
            this.parentType = 2;
        } else {
            throw new NeticaException("Doc objects do not exist for this class of objects");
        }
    }

    private Environ getEnv() throws NeticaException {
        switch (this.parentType) {
            case 1: {
                return ((Net)this.obj).parentEnv;
            }
            case 2: 
            case 3: {
                return ((Node)this.obj).parentEnv;
            }
        }
        return null;
    }

    private long getPtr() throws NeticaException {
        switch (this.parentType) {
            case 1: {
                return ((Net)this.obj).netPtr;
            }
            case 2: 
            case 3: {
                return ((Node)this.obj).nodePtr;
            }
        }
        return 0L;
    }

    public String getName() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetName_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeName_bn(this.getPtr());
                break;
            }
            case 3: {
                string = NETICA.GetNodeStateName_bn(this.getPtr(), this.stateIndex);
                if (string != null && !string.equals("")) break;
                string = "s" + this.stateIndex;
            }
        }
        this.getEnv().testForError();
        return string;
    }

    public void setName(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetName_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeName_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                NETICA.SetNodeStateName_bn(this.getPtr(), this.stateIndex, string);
            }
        }
        this.getEnv().testForError();
    }

    public String getTitle() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetTitle_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeTitle_bn(this.getPtr());
                break;
            }
            case 3: {
                string = NETICA.GetNodeStateTitle_bn(this.getPtr(), this.stateIndex);
            }
        }
        this.getEnv().testForError();
        return string;
    }

    public void setTitle(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetTitle_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeTitle_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                NETICA.SetNodeStateTitle_bn(this.getPtr(), this.stateIndex, string);
            }
        }
        this.getEnv().testForError();
    }

    public String getComment() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetComment_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeComment_bn(this.getPtr());
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
        return string;
    }

    public void setComment(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetComment_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeComment_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
    }

    String getRemark() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetRemark_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeRemark_bn(this.getPtr());
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
        return string;
    }

    void setRemark(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetRemark_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeRemark_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
    }

    String getIcon() throws NeticaException {
        String string = null;
        switch (this.parentType) {
            case 1: {
                string = NETICA.GetNetIcon_bn(this.getPtr());
                break;
            }
            case 2: {
                string = NETICA.GetNodeIcon_bn(this.getPtr());
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
        return string;
    }

    void setIcon(String string) throws NeticaException {
        switch (this.parentType) {
            case 1: {
                NETICA.SetNetIcon_bn(this.getPtr(), string);
                break;
            }
            case 2: {
                NETICA.SetNodeIcon_bn(this.getPtr(), string);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
    }

    public Object getUserData() throws NeticaException {
        if (this.parentType == 3) {
            throw new NeticaException("unsupported Doc feature for states");
        }
        return this.userData;
    }

    public void setUserData(Object object) throws NeticaException {
        if (this.parentType == 3) {
            throw new NeticaException("unsupported Doc feature for states");
        }
        this.userData = object;
    }

    public Object getUserField(String string) throws NeticaException {
        int[] nArray = new int[1];
        byte[] byArray = null;
        switch (this.parentType) {
            case 1: {
                byArray = NETICA.GetNetUserField_bn(this.getPtr(), string, nArray, 0);
                break;
            }
            case 2: {
                byArray = NETICA.GetNodeUserField_bn(this.getPtr(), string, nArray, 0);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
        if (byArray == null || nArray[0] == -1) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (IOException iOException) {
            try {
                return new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                throw new NeticaException("Doc.getUserField: IOException reading ObjectInputStream");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NeticaException("Doc.getUserField: ClassNotFoundException reading ObjectInputStream");
        }
    }

    public void setUserField(String string, Serializable serializable) throws NeticaException {
        if (serializable == null) {
            switch (this.parentType) {
                case 1: {
                    NETICA.SetNetUserField_bn(this.getPtr(), string, null, 0, 0);
                    break;
                }
                case 2: {
                    NETICA.SetNodeUserField_bn(this.getPtr(), string, null, 0, 0);
                    break;
                }
                case 3: {
                    throw new NeticaException("unsupported Doc feature for states");
                }
            }
        } else {
            Object object;
            if (serializable instanceof String) {
                String string2 = (String)((Object)serializable);
                try {
                    byte[] byArray = string2.getBytes("UTF-8");
                    switch (this.parentType) {
                        case 1: {
                            NETICA.SetNetUserField_bn(this.getPtr(), string, byArray, byArray.length, 0);
                            break;
                        }
                        case 2: {
                            NETICA.SetNodeUserField_bn(this.getPtr(), string, byArray, byArray.length, 0);
                            break;
                        }
                        case 3: {
                            throw new NeticaException("unsupported Doc feature for states");
                        }
                    }
                }
                catch (Exception exception) {
                    throw new NeticaException("Doc.setUserField: UTF-8 not a supported encoding!!");
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object).writeObject(serializable);
            }
            catch (IOException iOException) {
                throw new NeticaException("Doc.setUserField: IOException serializing fieldValue.");
            }
            object = byteArrayOutputStream.toByteArray();
            switch (this.parentType) {
                case 1: {
                    NETICA.SetNetUserField_bn(this.getPtr(), string, (byte[])object, ((Object)object).length, 0);
                    break;
                }
                case 2: {
                    NETICA.SetNodeUserField_bn(this.getPtr(), string, (byte[])object, ((Object)object).length, 0);
                    break;
                }
                case 3: {
                    throw new NeticaException("unsupported Doc feature for states");
                }
            }
        }
        this.getEnv().testForError();
    }

    public void getNthUserField(int n, String[] stringArray, Object[] objectArray) throws NeticaException {
        if (stringArray == null || stringArray.length < 1) {
            throw new NeticaException("Parameter name[] to Doc.getNthUserField() is null or of zero length.");
        }
        int[] nArray = new int[1];
        switch (this.parentType) {
            case 1: {
                NETICA.GetNetNthUserField_bn(this.getPtr(), n, stringArray, objectArray, nArray, 0);
                break;
            }
            case 2: {
                NETICA.GetNodeNthUserField_bn(this.getPtr(), n, stringArray, objectArray, nArray, 0);
                break;
            }
            case 3: {
                throw new NeticaException("unsupported Doc feature for states");
            }
        }
        this.getEnv().testForError();
        if (nArray[0] == -1 || stringArray == null || stringArray[0] == null) {
            stringArray[0] = "";
            if (objectArray != null && objectArray.length > 0) {
                objectArray[0] = "";
            }
            return;
        }
        if (objectArray != null && objectArray.length > 0 && objectArray[0] != null) {
            byte[] byArray = (byte[])objectArray[0];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                objectArray[0] = objectInputStream.readObject();
            }
            catch (IOException iOException) {
                try {
                    objectArray[0] = new String(byArray, "UTF-8");
                }
                catch (Exception exception) {
                    throw new NeticaException("Doc.getUserField: IOException reading ObjectInputStream");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NeticaException("Doc.getUserField: ClassNotFoundException reading ObjectInputStream");
            }
        }
    }
}

