/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.NodeList;

public class NetVisual {
    Net parentNet;
    Environ parentEnv;
    private long netPtr;
    private long visPtr;

    public NetVisual(Net net) throws NeticaException {
        this.parentNet = net;
        this.parentEnv = net.getEnviron();
        this.netPtr = net.netPtr;
    }

    public void layout(int n, double d, double d2, double d3, double d4, NodeList nodeList, double d5) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.LayoutNetVis_bn(this.netPtr, this.visPtr, n, d, d2, d3, d4, l, d5);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public void setLinksHidden(boolean bl) throws NeticaException {
        NETICA.SetNetVisLinksHidden_bn(this.netPtr, this.visPtr, bl);
        this.parentEnv.testForError();
    }

    public void setNodeLabling(int n) throws NeticaException {
        NETICA.SetNetVisNodeLabling_bn(this.netPtr, this.visPtr, n);
        this.parentEnv.testForError();
    }

    public void setNodeStyle(int n) throws NeticaException {
        NETICA.SetNetVisNodeStyle_bn(this.netPtr, this.visPtr, n);
        this.parentEnv.testForError();
    }

    public void setZoom(double d) throws NeticaException {
        NETICA.SetNetVisZoom_bn(this.netPtr, this.visPtr, d);
        this.parentEnv.testForError();
    }

    public void setWinPosition(double d, double d2) throws NeticaException {
        NETICA.SetNetVisWinPosition_bn(this.netPtr, this.visPtr, d, d2);
        this.parentEnv.testForError();
    }

    public void setWinScroll(double d, double d2) throws NeticaException {
        NETICA.SetNetVisWinScroll_bn(this.netPtr, this.visPtr, d, d2);
        this.parentEnv.testForError();
    }

    public void setWinStatus(int n) throws NeticaException {
        NETICA.SetNetVisWinStatus_bn(this.netPtr, this.visPtr, n);
        this.parentEnv.testForError();
    }
}

