/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Vector;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;

public class NeticaError {
    public static final int NOTHING_ERR = 1;
    public static final int REPORT_ERR = 2;
    public static final int NOTICE_ERR = 3;
    public static final int WARNING_ERR = 4;
    public static final int ERROR_ERR = 5;
    public static final int XXX_ERR = 6;
    public static final int OUT_OF_MEMORY_CND = 8;
    public static final int USER_ABORTED_CND = 32;
    public static final int FROM_WRAPPER_CND = 64;
    static final int JAVA_CND = 64;
    public static final int FROM_DEVELOPER_CND = 128;
    public static final int INCONS_FINDING_CND = 512;
    private long envPtr;
    private int errorNumber = -1;
    private int errorSeverity = -1;
    private int errorCategory = -1;
    private String msg;
    private long errorReportPtr = 0L;
    static final String[] errSeverityStrArray = new String[]{"UNDEFINED", "NOTHING_ERR", "REPORT_ERR", "NOTICE_ERR", "WARNING_ERR", "ERROR_ERR", "XXX_ERR"};
    static final String[] errCategoryStrArray = new String[]{"OUT_OF_MEMORY_CND", "USER_ABORTED_CND", "FROM_WRAPPER_CND", "FROM_DEVELOPER_CND", "INCONS_FINDING_CND"};

    NeticaError(long l, long l2) {
        if (l2 != 0L) {
            this.envPtr = l;
            this.errorReportPtr = l2;
            this.errorNumber = NETICA.ErrorNumber_ns(l2);
            this.errorSeverity = NETICA.ErrorSeverity_ns(l2);
            this.errorCategory = this.generateErrorCategory();
            this.msg = NETICA.ErrorMessage_ns(l2);
        }
    }

    NeticaError(int n, int n2, int n3, String string) {
        this.errorNumber = n;
        this.errorSeverity = n2;
        this.errorCategory = n3;
        this.msg = string;
    }

    public int getIdNumber() {
        return this.errorNumber;
    }

    public int getSeverity() {
        return this.errorSeverity;
    }

    public String getMessage() {
        return this.msg;
    }

    public boolean isInCategory(int n) {
        return NETICA.ErrorCategory_ns(n, this.errorReportPtr);
    }

    public static synchronized Vector getWarnings(int n) throws NeticaException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Environ environ = Environ.getDefaultEnviron();
                long l = NETICA.GetError_ns(environ.envPtr, n, 0L);
                if (l == 0L) break;
                Vector<NeticaError> vector = new Vector<NeticaError>();
                NeticaError neticaError = new NeticaError(environ.envPtr, l);
                if (neticaError.getSeverity() >= n && neticaError.getSeverity() <= 4) {
                    vector.add(neticaError);
                    neticaError.clearError();
                }
                while ((neticaError = neticaError.nextError()) != null) {
                    if (neticaError.getSeverity() < n || neticaError.getSeverity() > 4) continue;
                    vector.add(neticaError);
                }
                if (vector.size() == 0) {
                    return null;
                }
                return vector;
            }
            default: {
                throw new NeticaException("Illegal warning severity.  Must be one of: NOTHING_ERR, REPORT_ERR, NOTICE_ERR, or WARNING_ERR.");
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("** ErrorNumber   = ");
        stringBuffer.append(this.errorNumber);
        stringBuffer.append("\n");
        if (this.errorSeverity >= 0) {
            stringBuffer.append("** ErrorSeverity = ");
            stringBuffer.append(errSeverityStrArray[this.errorSeverity]);
            stringBuffer.append("\n");
        }
        if (this.errorCategory >= 0) {
            stringBuffer.append("** ErrorCategory = ");
            if ((this.errorCategory & 8) > 0) {
                stringBuffer.append(errCategoryStrArray[0] + "  ");
            }
            if ((this.errorCategory & 0x20) > 0) {
                stringBuffer.append(errCategoryStrArray[1] + "  ");
            }
            if ((this.errorCategory & 0x40) > 0) {
                stringBuffer.append(errCategoryStrArray[2] + "  ");
            }
            if ((this.errorCategory & 0x80) > 0) {
                stringBuffer.append(errCategoryStrArray[3] + "  ");
            }
            if ((this.errorCategory & 0x200) > 0) {
                stringBuffer.append(errCategoryStrArray[4] + "  ");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("** ErrorMessage  = ");
        stringBuffer.append(this.msg);
        return stringBuffer.toString();
    }

    NeticaError nextError() {
        long l = NETICA.GetError_ns(this.envPtr, 5, this.errorReportPtr);
        if (l == 0L) {
            return null;
        }
        return new NeticaError(this.envPtr, l);
    }

    private void clearError() throws NeticaException {
        if (this.errorReportPtr != 0L) {
            NETICA.ClearError_ns(this.errorReportPtr);
            this.errorReportPtr = 0L;
        }
    }

    private int generateErrorCategory() {
        int n = 0;
        if (NETICA.ErrorCategory_ns(8, this.errorReportPtr)) {
            n += 8;
        }
        if (NETICA.ErrorCategory_ns(32, this.errorReportPtr)) {
            n += 32;
        }
        if (NETICA.ErrorCategory_ns(128, this.errorReportPtr)) {
            n += 128;
        } else if (NETICA.ErrorCategory_ns(512, this.errorReportPtr)) {
            n += 512;
        } else if (NETICA.ErrorCategory_ns(64, this.errorReportPtr)) {
            n += 64;
        }
        return n;
    }
}

