/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Vector;
import norsys.netica.NeticaError;

public class NeticaException
extends Exception {
    static final int INTERNAL_ERROR_JAVAEXCEPTION = 6000;
    static final int NO_SUCH_CLASS_JAVAEXCEPTION = 6001;
    static final int INVALID_CLASS_JAVAEXCEPTION = 6002;
    static final int NULL_STRING_FOUND_JAVAEXCEPTION = 6003;
    static final int CONSTRUCTION_FAILED_JAVAEXCEPTION = 6004;
    static final int OPERATION_REQUESTED_ON_DELETED_PEER_JAVAEXCEPTION = 6005;
    static final int NULL_REFERENCE_JAVAEXCEPTION = 6006;
    static final int INVALID_CALLBACK_JAVAEXCEPTION = 6007;
    static final int GENERIC_JAVAEXCEPTION = 6498;
    static final int UNKNOWN_JAVAEXCEPTION = 6499;
    private Vector errors = new Vector();

    public NeticaException(String string) throws NeticaException {
        this(6498, string);
    }

    public NeticaException(int n, String string) throws NeticaException {
        super(string);
        NeticaError neticaError = null;
        if (n >= 6000 && n < 6500) {
            neticaError = new NeticaError(n, 5, 64, string);
        } else if (n >= 20000 && n < 30000) {
            neticaError = new NeticaError(n, 5, 192, string);
        } else {
            throw new NeticaException(6004, "Invalid User Defined Error. Error Numbers must be >= 20000, and < 30000.");
        }
        this.errors.add(neticaError);
    }

    NeticaException(long l, long l2) {
        if (l2 != 0L) {
            NeticaError neticaError = new NeticaError(l, l2);
            this.errors.add(neticaError);
            while ((neticaError = neticaError.nextError()) != null) {
                this.errors.add(neticaError);
            }
        }
    }

    public Vector getNeticaErrors() {
        return this.errors;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n**************  E R R O R  ***************\n");
        int n = 0;
        while (n < this.errors.size()) {
            if (n > 0) {
                stringBuffer.append("------------------------- Error # ");
                stringBuffer.append(n + 1);
                stringBuffer.append("\n");
            }
            NeticaError neticaError = (NeticaError)this.errors.get(n);
            stringBuffer.append(neticaError.toString());
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("******************************************\n");
        return stringBuffer.toString();
    }
}

