/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Hashtable;
import java.util.StringTokenizer;
import norsys.netica.Doc;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaEvent;
import norsys.netica.NeticaException;
import norsys.netica.NeticaListener;
import norsys.netica.NodeList;
import norsys.netica.NodeVisual;
import norsys.netica.Util;

public class Node
implements NeticaListener {
    public static final int CONTINUOUS_TYPE = 101;
    public static final int DISCRETE_TYPE = 102;
    public static final int TEXT_TYPE = 103;
    public static final int NATURE_NODE = 201;
    public static final int CONSTANT_NODE = 202;
    public static final int DECISION_NODE = 203;
    public static final int UTILITY_NODE = 204;
    public static final int DISCONNECTED_NODE = 205;
    public static final int EVERY_STATE = -5;
    public static final int IMPOSS_STATE = -4;
    public static final int UNDEF_STATE = -3;
    public static final int NEGATIVE_FINDING = -7;
    public static final int LIKELIHOOD_FINDING = -6;
    public static final int NO_FINDING = -3;
    long nodePtr;
    long callbackPtr;
    Net parentNet;
    Environ parentEnv;
    private Object userData;
    private NodeVisual visual;
    private Doc doc;
    private Hashtable listeners = new Hashtable();
    private static String constructorClassName = "norsys.netica.Node";
    private Doc[] stateDoc;

    public Node(String string, int n, Net net) throws NeticaException {
        long l = NETICA.NewNode_bn(string, n, net.netPtr);
        net.parentEnv.testForError();
        this.hookupToNative(l, net);
    }

    public Node(String string, String string2, Net net) throws NeticaException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",< \t;:.(){}[]>");
        int n = stringTokenizer.countTokens();
        long l = NETICA.NewNode_bn(string, n, net.netPtr);
        net.parentEnv.testForError();
        this.hookupToNative(l, net);
        this.setStateNames(string2);
    }

    public Node() {
    }

    void hookupToNative(long l, Net net) throws NeticaException {
        this.parentNet = net;
        this.parentEnv = net.parentEnv;
        this.nodePtr = l;
        NETICA.SetJavaApiNode_bn(l, this);
        if (this.getKind() != 205) {
            this.parentEnv.testForError();
            this.callbackPtr = NETICA.AddNodeListener_bn(l, 0L, this, -1);
        }
        this.parentEnv.testForError();
        Util.log("NETICA: created Node: " + this.doc().getName());
    }

    public static String getConstructorClassName() {
        return constructorClassName;
    }

    public static void setConstructorClassName(String string) throws NeticaException {
        Class<?> clazz;
        Class<?> clazz2;
        Object var1_1 = null;
        try {
            clazz2 = Class.forName(string);
            clazz = Class.forName("norsys.netica.Node");
        }
        catch (Exception exception) {
            throw new NeticaException(6001, "The class " + string + " could not be found on the classpath.");
        }
        try {
            var1_1 = clazz2.newInstance();
        }
        catch (Exception exception) {
            throw new NeticaException(6002, "The class " + string + " does not have a default construtor.");
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new NeticaException(6002, string + " is not an extension of norsys.netica.Node");
        }
        constructorClassName = string;
    }

    public void eventOccurred(NeticaEvent neticaEvent) throws NeticaException {
        if (this.nodePtr == 0L) {
            System.err.println("*** Internal Netica-J Error ***  Got eventOccurred( ) call when nodePtr==0\u0007");
            return;
        }
        Util.log("*** Node.eventOccurred() was called with event.id = " + neticaEvent.getId());
        try {
            switch (neticaEvent.getId()) {
                case 4: {
                    Util.log(" DELETE_EVENT received by node: " + this.doc().getName());
                    this.onDeleteCallback(neticaEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("********************************************************* ");
            System.err.println("**  Netica-J Internal Error in Node.evenOccurred()     ** ");
            System.err.println("**  Please inform Norsys by e-mailing info@norsys.com  ** ");
            System.err.println("********************************************************* ");
            exception.printStackTrace();
        }
    }

    void onDeleteCallback(NeticaEvent neticaEvent) throws NeticaException {
        Util.log("Node.onDeleteCallback() called.");
        if (neticaEvent.getObject() != this) {
            if (Util.devel) {
                System.out.println(" *** WARNING *** NETICA_J. Node.onDeleteCallback().  Notified of event on object I'm not listening to:   event.id=" + neticaEvent.getId() + "    Event was on object" + neticaEvent.getObject());
            }
            return;
        }
        NETICA.AddNodeListener_bn(this.nodePtr, this.callbackPtr, this, 0);
        Util.log(" *** Node:onDeleteCallback SUCCESS!!");
        this.nodePtr = 0L;
    }

    void assertNodeIsViable() throws NeticaException {
        if (this.parentEnv == null || this.parentEnv.envPtr == 0L) {
            throw new NeticaException(6005, "The Environ associated with this object has been closed and so this object should no longer be used.");
        }
        if (this.nodePtr == 0L) {
            throw new NeticaException(6005, "Native node object no longer exists, so this Node should no longer be used.");
        }
    }

    static Node getNodeFromPtr(long l, Net net) throws NeticaException {
        Node node = NETICA.GetJavaApiNode_bn(l);
        if (node == null) {
            try {
                Class<?> clazz = Class.forName(Node.getConstructorClassName());
                node = (Node)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new NeticaException(6000, "Internal error during Node construction.");
            }
            node.hookupToNative(l, net);
        } else if (Util.devel) {
            System.out.println("**** SUCCESSFULLY reusing a Node, YIPPEE!!!");
        }
        return node;
    }

    public Net getNet() {
        return this.parentNet;
    }

    public void addListener(NeticaListener neticaListener) throws NeticaException {
        long l = NETICA.AddNodeListener_bn(this.nodePtr, 0L, neticaListener, -1);
        this.parentEnv.testForError();
        this.listeners.put(neticaListener, new Long(l));
    }

    public void removeListener(NeticaListener neticaListener) throws NeticaException {
        Object v = this.listeners.get(neticaListener);
        if (v == null || !(v instanceof Long)) {
            throw new NeticaException("The object supplied is not on record as a current listener; you must call addListener() with a Listener object before calling removeListener() on the same object.");
        }
        Long l = (Long)v;
        NETICA.AddNodeListener_bn(this.nodePtr, l, neticaListener, 0);
        this.parentEnv.testForError();
        this.listeners.remove(neticaListener);
    }

    public void setStateNames(String string) throws NeticaException {
        NETICA.SetNodeStateNames_bn(this.nodePtr, string);
        this.parentEnv.testForError();
    }

    public int addLink(Node node) throws NeticaException {
        int n = NETICA.AddLink_bn(node.nodePtr, this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public int getNumStates() throws NeticaException {
        int n = NETICA.GetNodeNumberStates_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public void setCPTable(int[] nArray, float[] fArray) throws NeticaException {
        NETICA.SetNodeProbs_bn(this.nodePtr, nArray, fArray);
        this.parentEnv.testForError();
    }

    public void setCPTable(String string, float[] fArray) throws NeticaException {
        this.setCPTable(this.parentStatesToIndexes(string), fArray);
    }

    public int getStateIndex(String string) throws NeticaException {
        int n = NETICA.StateNamed_bn(string, this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public boolean isDeterministic() throws NeticaException {
        boolean bl = NETICA.IsNodeDeterministic_bn(this.nodePtr);
        this.parentEnv.testForError();
        return bl;
    }

    public int getType() throws NeticaException {
        int n = NETICA.GetNodeType_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n + 100;
    }

    public boolean hasTable(boolean[] blArray) throws NeticaException {
        if (blArray != null && blArray.length < 1) {
            throw new NeticaException("Parameter complete[] to Node.hasTable() is of zero length.");
        }
        boolean bl = NETICA.HasNodeTable_bn(this.nodePtr, blArray);
        this.parentEnv.testForError();
        return bl;
    }

    public int getKind() throws NeticaException {
        int n = NETICA.GetNodeKind_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n + 200;
    }

    public void setKind(int n) throws NeticaException {
        if (n < 201 || n > 205) {
            throw new NeticaException("Invalid kind; must be one of: NATURE_NODE, CONSTANT_NODE, DECISION_NODE, UTILITY_NODE, or DISCONNECTED_NODE.");
        }
        NETICA.SetNodeKind_bn(this.nodePtr, n - 200);
        this.parentEnv.testForError();
    }

    public String getInputName(int n) throws NeticaException {
        String string = NETICA.GetNodeInputName_bn(this.nodePtr, n);
        this.parentEnv.testForError();
        return string;
    }

    public void setInputName(int n, String string) throws NeticaException {
        NETICA.SetNodeInputName_bn(this.nodePtr, n, string);
        this.parentEnv.testForError();
    }

    public void finalize() throws NeticaException {
        if (this.nodePtr != 0L) {
            NETICA.AddNetListener_bn(this.nodePtr, this.callbackPtr, this, 0);
        }
    }

    public void delete() throws NeticaException {
        if (this.nodePtr == 0L) {
            throw new NeticaException(6005, "Node.delete(): Native node was already deleted.");
        }
        String string = this.doc().getName();
        NETICA.DeleteNode_bn(this.nodePtr);
        this.parentEnv.testForError();
        Util.log("NETICA: deleted Node: " + string);
    }

    public NodeList getParents() throws NeticaException {
        long l = NETICA.GetNodeParents_bn(this.nodePtr);
        this.parentEnv.testForError();
        return new NodeList(l, this.parentNet);
    }

    public NodeList getChildren() throws NeticaException {
        long l = NETICA.GetNodeChildren_bn(this.nodePtr);
        this.parentEnv.testForError();
        return new NodeList(l, this.parentNet);
    }

    public void deleteLink(int n) throws NeticaException {
        NETICA.DeleteLink_bn(n, this.nodePtr);
        this.parentEnv.testForError();
    }

    public double[] getLevels() throws NeticaException {
        double[] dArray = NETICA.GetNodeLevels_bn(this.nodePtr);
        this.parentEnv.testForError();
        return dArray;
    }

    public void setLevels(double[] dArray) throws NeticaException {
        if (dArray == null) {
            NETICA.SetNodeLevels_bn(this.nodePtr, 0, null);
        } else if (this.getType() == 102) {
            NETICA.SetNodeLevels_bn(this.nodePtr, this.getNumStates(), dArray);
        } else {
            NETICA.SetNodeLevels_bn(this.nodePtr, dArray.length - 1, dArray);
        }
        this.parentEnv.testForError();
    }

    public void switchParent(int n, Node node) throws NeticaException {
        if (node == null) {
            NETICA.SwitchNodeParent_bn(n, this.nodePtr, 0L);
        } else {
            NETICA.SwitchNodeParent_bn(n, this.nodePtr, node.nodePtr);
        }
        this.parentEnv.testForError();
    }

    public String getEquation() throws NeticaException {
        String string = NETICA.GetNodeEquation_bn(this.nodePtr);
        this.parentEnv.testForError();
        return string;
    }

    public void setEquation(String string) throws NeticaException {
        NETICA.SetNodeEquation_bn(this.nodePtr, string);
        this.parentEnv.testForError();
    }

    public void equationToTable(int n, boolean bl, boolean bl2) throws NeticaException {
        NETICA.EquationToTable_bn(this.nodePtr, n, bl, bl2);
        this.parentEnv.testForError();
    }

    public float[] getCPTable(int[] nArray, float[] fArray) throws NeticaException {
        float[] fArray2 = NETICA.GetNodeProbs_bn(this.nodePtr, nArray, fArray);
        this.parentEnv.testForError();
        return fArray2;
    }

    public int[] getStateFuncTable(int[] nArray, int[] nArray2) throws NeticaException {
        if (nArray2 == null || nArray2.length == 0) {
            int[] nArray3 = new int[]{NETICA.GetNodeFuncState_bn(this.nodePtr, nArray)};
            this.parentEnv.testForError();
            return nArray3;
        }
        nArray2[0] = NETICA.GetNodeFuncState_bn(this.nodePtr, nArray);
        this.parentEnv.testForError();
        return nArray2;
    }

    public void setStateFuncTable(int[] nArray, int n) throws NeticaException {
        NETICA.SetNodeFuncState_bn(this.nodePtr, nArray, n);
        this.parentEnv.testForError();
    }

    public double[] getRealFuncTable(int[] nArray, double[] dArray) throws NeticaException {
        if (dArray == null || dArray.length == 0) {
            double[] dArray2 = new double[]{NETICA.GetNodeFuncReal_bn(this.nodePtr, nArray)};
            this.parentEnv.testForError();
            return dArray2;
        }
        dArray[0] = NETICA.GetNodeFuncReal_bn(this.nodePtr, nArray);
        this.parentEnv.testForError();
        return dArray;
    }

    public void setRealFuncTable(int[] nArray, double d) throws NeticaException {
        NETICA.SetNodeFuncReal_bn(this.nodePtr, nArray, d);
        this.parentEnv.testForError();
    }

    public double[] getExperTable(int[] nArray, double[] dArray) throws NeticaException {
        if (dArray == null || dArray.length == 0) {
            double[] dArray2 = new double[]{NETICA.GetNodeExperience_bn(this.nodePtr, nArray)};
            this.parentEnv.testForError();
            return dArray2;
        }
        dArray[0] = NETICA.GetNodeExperience_bn(this.nodePtr, nArray);
        this.parentEnv.testForError();
        return dArray;
    }

    public void setExperTable(int[] nArray, double d) throws NeticaException {
        NETICA.SetNodeExperience_bn(this.nodePtr, nArray, d);
        this.parentEnv.testForError();
    }

    public void fadeCPTable(double d) throws NeticaException {
        NETICA.FadeCPTable_bn(this.nodePtr, d);
        this.parentEnv.testForError();
    }

    public void deleteTables() throws NeticaException {
        NETICA.DeleteNodeTables_bn(this.nodePtr);
        this.parentEnv.testForError();
    }

    public void reverseLink(Node node) throws NeticaException {
        NETICA.ReverseLink_bn(node.nodePtr, this.nodePtr);
        this.parentEnv.testForError();
    }

    public void enterFinding(int n) throws NeticaException {
        NETICA.EnterFinding_bn(this.nodePtr, n);
        this.parentEnv.testForError();
    }

    public void enterFindingNot(int n) throws NeticaException {
        NETICA.EnterFindingNot_bn(this.nodePtr, n);
        this.parentEnv.testForError();
    }

    public void enterValue(double d) throws NeticaException {
        NETICA.EnterNodeValue_bn(this.nodePtr, d);
        this.parentEnv.testForError();
    }

    public void enterLikelihood(float[] fArray) throws NeticaException {
        NETICA.EnterNodeLikelihood_bn(this.nodePtr, fArray);
        this.parentEnv.testForError();
    }

    public float[] getLikelihood() throws NeticaException {
        float[] fArray = NETICA.GetNodeLikelihood_bn(this.nodePtr);
        this.parentEnv.testForError();
        return fArray;
    }

    public void retractFindings() throws NeticaException {
        NETICA.RetractNodeFindings_bn(this.nodePtr);
        this.parentEnv.testForError();
    }

    public int getFinding() throws NeticaException {
        int n = NETICA.GetNodeFinding_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public double getValueEntered() throws NeticaException {
        double d = NETICA.GetNodeValueEntered_bn(this.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    public int calcState() throws NeticaException {
        int n = NETICA.CalcNodeState_bn(this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public double calcValue() throws NeticaException {
        double d = NETICA.CalcNodeValue_bn(this.nodePtr);
        this.parentEnv.testForError();
        return d;
    }

    public float[] getExpectedUtils() throws NeticaException {
        float[] fArray = NETICA.GetNodeExpectedUtils_bn(this.nodePtr);
        this.parentEnv.testForError();
        return fArray;
    }

    public double getExpectedValue(double[] dArray) throws NeticaException {
        double[] dArray2 = new double[1];
        double d = NETICA.GetNodeExpectedValue_bn(this.nodePtr, dArray2, null, null);
        this.parentEnv.testForError();
        if (dArray != null) {
            if (dArray.length > 0) {
                dArray[0] = d;
            }
            if (dArray.length > 1) {
                dArray[1] = dArray2[0];
            }
        }
        return d;
    }

    public boolean isBeliefUpdated() throws NeticaException {
        boolean bl = NETICA.IsBeliefUpdated_bn(this.nodePtr);
        this.parentEnv.testForError();
        return bl;
    }

    static int[] stringToStates(String string, NodeList nodeList) throws NeticaException {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",< \t;:.(){}[]>");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) {
                nArray[n++] = -5;
                continue;
            }
            long l = ((Node)nodeList.get((int)n)).nodePtr;
            nArray[n] = NETICA.StateNamed_bn(string2, l);
            ++n;
        }
        return nArray;
    }

    public int[] parentStatesToIndexes(String string) throws NeticaException {
        return Node.stringToStates(string, this.getParents());
    }

    public String toString() {
        try {
            return this.doc().getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public float[] getBeliefs() throws NeticaException {
        float[] fArray = NETICA.GetNodeBeliefs_bn(this.nodePtr);
        this.parentEnv.testForError();
        return fArray;
    }

    public int getInputIndex(String string) throws NeticaException {
        int n = NETICA.InputNamed_bn(string, this.nodePtr);
        this.parentEnv.testForError();
        return n;
    }

    public NodeVisual getVisual() throws NeticaException {
        if (this.visual == null) {
            this.visual = new NodeVisual(this);
        }
        return this.visual;
    }

    public Doc doc() throws NeticaException {
        if (this.doc == null) {
            this.doc = new Doc(this);
        }
        return this.doc;
    }

    public Doc docState(int n) throws NeticaException {
        int n2 = this.getNumStates();
        if (n2 > 10000) {
            throw new NeticaException("Too many states (" + n2 + " > limit of 10000); state doc not-allowed.\n  If you would like this limitation lifted, please contact Norsys (mail@norsys.com) with your request.");
        }
        if (this.stateDoc == null) {
            if (n2 <= 0) {
                throw new NeticaException("This node does not have discrete states");
            }
            this.stateDoc = new Doc[n2];
        }
        if (n >= n2) {
            throw new NeticaException("stateIndex is out of range 0.." + (n2 - 1));
        }
        if (this.stateDoc[n] == null) {
            this.stateDoc[n] = new Doc(this, n);
        }
        return this.stateDoc[n];
    }

    public Doc docState(String string) throws NeticaException {
        return this.docState(this.getStateIndex(string));
    }

    public void enterFinding(String string) throws NeticaException {
        int n = this.getStateIndex(string);
        this.enterFinding(n);
    }

    public float getBelief(String string) throws NeticaException {
        float[] fArray = NETICA.GetNodeBeliefs_bn(this.nodePtr);
        this.parentEnv.testForError();
        return fArray[this.getStateIndex(string)];
    }

    public float[] getCPTable(String string, float[] fArray) throws NeticaException {
        return this.getCPTable(this.parentStatesToIndexes(string), fArray);
    }
}

