/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Enumeration;
import java.util.Vector;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.Net;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.Util;

public class NodeList
extends Vector {
    Net parentNet;
    Environ parentEnv;

    public NodeList(int n, Net net) throws NeticaException {
        super(n);
        this.parentNet = net;
        this.parentEnv = net.parentEnv;
        Util.log("NETICA: created empty NodeList of length: " + n);
    }

    public NodeList(NodeList nodeList) throws NeticaException {
        super(nodeList);
        this.parentNet = nodeList.parentNet;
        this.parentEnv = nodeList.parentEnv;
        Util.log("NETICA: copy constructed a NodeList of length: " + this.size());
    }

    NodeList(long l, Net net) throws NeticaException {
        super(NETICA.LengthNodeList_bn(l));
        this.parentNet = net;
        this.parentEnv = net.parentEnv;
        this.parentEnv.testForError();
        int n = this.capacity();
        int n2 = 0;
        while (n2 < n) {
            long l2 = NETICA.NthNode_bn(l, n2);
            if (l2 == 0L) {
                this.add((Object)null);
            } else {
                Node node = Node.getNodeFromPtr(l2, net);
                this.add(node);
            }
            ++n2;
        }
        Util.log("NETICA: created NodeList of length: " + n);
    }

    public Net getNet() {
        return this.parentNet;
    }

    synchronized long getNodeListPtr() throws NeticaException {
        long l = NETICA.NewNodeList_bn(0, this.parentEnv.envPtr);
        Enumeration enumeration = this.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            Util.log("nodelist[" + n + "]=" + node.doc().getName());
            NETICA.AddNodeToList_bn(node.nodePtr, l, n++);
        }
        return l;
    }

    public boolean add(Object object) {
        Node node;
        if (object instanceof Node && (node = (Node)object).getNet().equals(this.parentNet)) {
            return super.add(object);
        }
        return false;
    }

    public void add(int n, Object object) {
        Node node;
        if (object instanceof Node && (node = (Node)object).getNet().equals(this.parentNet)) {
            super.add(n, object);
        }
    }

    public void addElement(Object object) {
        Node node;
        if (object instanceof Node && (node = (Node)object).getNet().equals(this.parentNet)) {
            super.addElement(object);
        }
    }

    public static int[] mapStateList(int[] nArray, NodeList nodeList, NodeList nodeList2) throws NeticaException {
        if (nArray.length != nodeList.size() || nArray.length != nodeList2.size()) {
            throw new NeticaException("srcStates.length, srcNodes.size(), and destNodes.size() must all be of equal length.");
        }
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nodeList.size()) {
            Node node = (Node)nodeList.get(n);
            int n2 = nodeList2.indexOf(node);
            nArray2[n2] = nArray[n];
            ++n;
        }
        return nArray2;
    }

    public Node getNode(int n) throws ArrayIndexOutOfBoundsException {
        return (Node)this.get(n);
    }
}

