/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Node;

public class NodeVisual {
    static final int LABELED_BOX_NODE_STYLE = 1;
    static final int CIRCLE_NODE_STYLE = 2;
    static final int ABSENT_NODE_STYLE = 3;
    static final int BELIEF_BAR_NODE_STYLE = 4;
    static final int TITLE_LABEL = 1;
    static final int NAME_LABEL = 2;
    static final int NAME_COLON_TITLE_LABEL = 3;
    static final int TITLE_PAREN_NAME_LABEL = 4;
    Node parentNode;
    private long visPtr;

    NodeVisual(Node node) throws NeticaException {
        this.parentNode = node;
    }

    public double[] getPosition() throws NeticaException {
        double[] dArray = new double[2];
        NETICA.GetNodeVisPosition_bn(this.parentNode.nodePtr, 0L, dArray);
        this.parentNode.parentEnv.testForError();
        return dArray;
    }

    public void setPosition(double d, double d2) throws NeticaException {
        NETICA.SetNodeVisPosition_bn(this.parentNode.nodePtr, 0L, d, d2);
        this.parentNode.parentEnv.testForError();
    }

    void setFont(String string, double d, int n) throws NeticaException {
        NETICA.SetNodeVisFont_bn(this.parentNode.nodePtr, this.visPtr, string, d, n);
        this.parentNode.parentEnv.testForError();
    }

    void setHidden(boolean bl) throws NeticaException {
        NETICA.SetNodeVisHidden_bn(this.parentNode.nodePtr, this.visPtr, bl);
        this.parentNode.parentEnv.testForError();
    }

    void setMaxStates(int n) throws NeticaException {
        NETICA.SetNodeVisMaxStates_bn(this.parentNode.nodePtr, this.visPtr, n);
        this.parentNode.parentEnv.testForError();
    }

    void setSize(double d, double d2) throws NeticaException {
        NETICA.SetNodeVisSize_bn(this.parentNode.nodePtr, this.visPtr, d, d2);
        this.parentNode.parentEnv.testForError();
    }

    void setStyle(int n) throws NeticaException {
        NETICA.SetNodeVisStyle_bn(this.parentNode.nodePtr, this.visPtr, n);
        this.parentNode.parentEnv.testForError();
    }
}

