/**
 * A sample extension of norsys.netica.Node
 */

import norsys.netica.*;

public class Node extends norsys.netica.Node{

  //------------------------------------------------------------ constructors
  public Node( String name, int num_states, Net parentNet ) throws NeticaException {
      super( name, num_states, parentNet );
  }

  public Node( String name, String stateNames, Net parentNet ) throws NeticaException {
      super( name, stateNames, parentNet );
  }

  public Node() {};

    //------------------------------------------------------------

  /** 
   *  
   */
  public void setCPTable( String parentStateNames, double prob1, double prob2 ) 
    throws NeticaException 
  {
    float[] cpTable = new float[2];
    cpTable[0] = (float) prob1;
    cpTable[1] = (float) prob2;
    setCPTable( parentStateNames, cpTable );
  }

  /** 
   *  
   */
  public void setCPTable( double prob1, double prob2 ) 
    throws NeticaException 
  {
    setCPTable( new String(),  prob1, prob2 );
  }

}
