/* 
 *  BuildNet.java
 *
 *  Example use of Netica-J for constructing a Bayes net and
 *  saving it to file.
 */
import NodeEx;
import norsys.netica.*;
     
public class BuildNet {

  public static void main (String[] args){
    try {
	Node.setConstructorClassName ("NodeEx");
	Environ env = new Environ (null);

	Net net = new Net();
	net.doc().setName("AsiaEx");

	NodeEx tuberculosis = new NodeEx ("Tuberculosis","present,absent",  net);
	NodeEx smoking      = new NodeEx ("Smoking",     "smoker,nonsmoker",net);
	NodeEx cancer       = new NodeEx ("Cancer",      "present,absent",  net);
	NodeEx tbOrCa       = new NodeEx ("TbOrCa",      "true,false",      net);
	NodeEx xRay         = new NodeEx ("XRay",        "abnormal,normal", net);
	NodeEx visitAsia    = new NodeEx ("VisitAsia",   "visit,no_visit",  net);
	visitAsia.docState("visit").setTitle ("Visited Asia within last 3 years");
	
	tuberculosis.addLink (visitAsia); // link from visitAsia to tuberculosis
	cancer.addLink (smoking);
	tbOrCa.addLink (tuberculosis);
	tbOrCa.addLink (cancer);
	xRay.addLink (tbOrCa);

	visitAsia.setCPTable (0.01, 0.99);

	//                        VisitAsia   present  absent
	tuberculosis.setCPTable ("visit",     0.05,    0.95);
	tuberculosis.setCPTable ("no_visit",  0.01,    0.99);
	
	smoking.setCPTable (0.5, 0.5);

	//                  Smoking      present  absent
	cancer.setCPTable ("smoker",     0.1,     0.9);
	cancer.setCPTable ("nonsmoker",  0.01,    0.99);
	
	tbOrCa.setEquation ("TbOrCa (Tuberculosis, Cancer) = Tuberculosis || Cancer");
	tbOrCa.equationToTable (1, false, false);

	//               TbOrCa     abnormal normal
	xRay.setCPTable ("true",    0.98,    0.02);
	xRay.setCPTable ("false",   0.05,    0.95);

	Streamer stream = new Streamer ("AsiaEx.dne");
	net.write (stream);

	net.delete();
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}
