/* 
 *  DoInference.java
 *
 *  Example use of Netica-J for doing probabilistic inference.
 */
import NetEx;
import NodeEx;
import norsys.netica.*;
     
public class DoInference {

  public static void main (String[] args){
    try {
	Node.setConstructorClassName ("NodeEx");
	Environ env = new Environ (null);

	Streamer stream = new Streamer ("AsiaEx.dne");
	NetEx net = new NetEx(stream);

	NodeEx  visitAsia    = (NodeEx) net.getNode( "VisitAsia"    );
	NodeEx  tuberculosis = (NodeEx) net.getNode( "Tuberculosis" );
	NodeEx  xRay         = (NodeEx) net.getNode( "XRay"         );

	net.compile();

	double belief = tuberculosis.getBelief ("present");          
	System.out.println ("\nThe probability of tuberculosis is " + belief);

	xRay.enterFinding ("abnormal");
	belief = tuberculosis.getBelief ("present");          
	System.out.println ("\nGiven an abnormal X-ray,\n"+
			    "the probability of tuberculosis is " + belief);

	visitAsia.enterFinding ("visit");
	belief = tuberculosis.getBelief ("present");          
	System.out.println ("\nGiven an abnormal X-ray and a visit to Asia,\n" +
			    "the probability of tuberculosis is " + belief + "\n");

	net.delete();
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}
