/* 
 *  Learning.java
 *
 *  Example use of Netica-J for learning the CPTs of a Bayes net
 *  from a file of cases.
 */

import NetEx;
import NodeEx;
import norsys.netica.*;
import java.io.File;

public class Learning {

  public static void main(String[] args) {
    System.out.println( "Running Netica-J Learning example..." );

    try {
	Environ env = new Environ (null);
	Net.setConstructorClassName ("NetEx");
	Node.setConstructorClassName ("NodeEx");

	Streamer   netFile    = new Streamer ("AsiaEx.dne");
	NetEx      origNet    = new NetEx (netFile);
	NodeList origNodes    = origNet.getNodes();

	NetEx    learnedNet   = new NetEx();

	//-- duplicate all the nodes from origNet into learnedNet
	NodeList learnedNodes = origNet.duplicateNodes (origNodes, learnedNet);
	int      numNodes     = learnedNodes.size();
	
	//-- remove CPTables of nodes in learned net, so new ones can be learned.
	for (int n=0; n < numNodes; n++) {
	    NodeEx node = (NodeEx) learnedNodes.get (n);
	    node.deleteTables();
	}
	
	(new File("temp.cases")).delete(); // in case "temp.cases" existed from 
	                                   // a previous run
	Streamer caseFile = new Streamer ("temp.cases");

	origNet.compile();
	
	int numCases = 120;
	for (int n=0; n < numCases; n++) {
	    origNet.retractFindings();
	    int res = origNet.generateRandomCase (origNodes, 0, 20);
	    if (res >= 0) {
		origNet.writeCase (origNodes, caseFile, n, -1.0);
	    }
	}
	//-- So, now we read back the cases and try to learn a net with CPTables
	//-- similar to origNet. 

	long[] casePosn = new long[1];
	casePosn[0] = Net.FIRST_CASE;
	while (true) {
	    learnedNet.retractFindings();
	    learnedNet.readCase (casePosn, caseFile, learnedNodes, null, null);
	    if (casePosn[0] == Net.NO_MORE_CASES) break;
	    
	    learnedNet.reviseCPTsByFindings (learnedNodes, 1.0);
	    casePosn[0] = Net.NEXT_CASE;
	}
	
	netFile  = new Streamer ("Learned_AsiaEx.dne");
	learnedNet.write (netFile);
	
	origNet.delete();
	learnedNet.delete();
    }
    catch (Exception e) {
	e.printStackTrace();
    }
  }
}

