/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import norsys.netica.Environ;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Util;

public class Streamer {
    Environ parentEnv;
    long streamPtr;
    OutputStream outputStream = null;
    String streamerFileName = null;
    String tempFileName = "temp" + Math.random() + ".txt";
    File tempFile = null;

    public Streamer(String string) throws NeticaException {
        this(string, Environ.getDefaultEnviron());
    }

    public Streamer(String string, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.streamPtr = NETICA.NewStreamFile_ns(string, this.parentEnv.envPtr, null);
        this.parentEnv.testForError();
        this.streamerFileName = string;
        if (this.streamPtr == 0L) {
            throw new NeticaException(6004, "Streamer: Construction failed.");
        }
        Util.log("NETICA: created Streamer for file: " + string);
    }

    public Streamer(InputStream inputStream, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        int n = 0;
        byte[] byArray = new byte[10000];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        try {
            while ((n = inputStream.read(byArray, 0, 10000)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            this.tempFile = new File(this.tempFileName);
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
            byteArrayOutputStream.writeTo(fileOutputStream);
            fileOutputStream.close();
            this.tempFile = new File(this.tempFileName);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new NeticaException("Streamer(InputStream, Environ): IOException reading InputStream");
        }
        this.streamPtr = NETICA.NewStreamFile_ns(this.tempFileName, environ.envPtr, null);
        environ.testForError();
    }

    public Streamer(OutputStream outputStream, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.outputStream = outputStream;
        this.streamPtr = NETICA.NewStreamFile_ns(this.tempFileName, environ.envPtr, null);
        File file = new File(this.tempFileName);
    }

    public Environ getEnviron() throws NeticaException {
        return this.parentEnv;
    }

    public String getFileName() throws NeticaException {
        return this.streamerFileName;
    }

    public void flush() throws NeticaException {
        File file;
        if (this.streamPtr != 0L && this.outputStream != null && (file = new File(this.tempFileName)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                int n = 0;
                byte[] byArray = new byte[10000];
                while ((n = bufferedInputStream.read(byArray, 0, 10000)) != -1) {
                    this.outputStream.write(byArray, 0, n);
                }
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                throw new NeticaException("Streamer.flush(): IOException reading tempFile: " + this.tempFileName);
            }
        }
    }

    public void finalize() throws NeticaException {
        if (this.streamPtr == 0L) {
            return;
        }
        if (this.outputStream != null) {
            this.flush();
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                throw new NeticaException("Streamer.finalize(): IOException closing outputStream");
            }
        }
        this.tempFile = new File(this.tempFileName);
        if (this.tempFile.exists() && !this.tempFile.delete()) {
            System.err.println("***WARNING*** TempFile Didn't delete properly. Please delete " + this.tempFileName + " manually.");
        }
        NETICA.DeleteStream_ns(this.streamPtr);
        this.parentEnv.testForError();
        this.streamPtr = 0L;
    }

    public void close() throws NeticaException {
        this.finalize();
    }
}

