/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import norsys.netica.Environ;
import norsys.netica.General;
import norsys.netica.NETICA;
import norsys.netica.NeticaEvent;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.NodeList;
import norsys.netica.Streamer;
import norsys.netica.Util;

public class Net
extends General {
    long netPtr;
    private Object userData;
    private static String constructorClass = "norsys.netica.Net";
    static int objectCount = 0;
    public static final int BELIEF_UPDATE = 256;
    public static final long FIRST_CASE = -15L;
    public static final long NEXT_CASE = -14L;
    public static final long NO_MORE_CASES = -13L;
    static final int READNET_NO_VISUAL_INFO = 0;
    static final int READNET_NO_WINDOW = 16;
    static final int READNET_MINIMIZED_WINDOW = 48;
    static final int READNET_REGULAR_WINDOW = 112;

    static synchronized int newObjectCount() {
        return ++objectCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Net(Environ environ) throws NeticaException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            long l = NETICA.NewNet_bn("Unnamed_" + Net.newObjectCount(), environ.envPtr);
            environ.testForError();
            this.hookupToNative(l, environ);
        }
    }

    public Net() throws NeticaException {
        this(Environ.getDefaultEnviron());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Net(Streamer streamer) throws NeticaException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.parentEnv = streamer.parentEnv;
            this.netPtr = NETICA.ReadNet_bn(streamer.streamPtr, 16);
            this.parentEnv.testForError();
            this.hookupToNative(this.netPtr, this.parentEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Net(Net net, String string, Environ environ, String string2) throws NeticaException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.parentEnv = environ;
            this.netPtr = NETICA.CopyNet_bn(net.netPtr, string, environ.envPtr, string2);
            net.getEnviron().testForError();
            this.parentEnv.testForError();
            this.hookupToNative(this.netPtr, this.parentEnv);
        }
    }

    private void hookupToNative(long l, Environ environ) throws NeticaException {
        this.parentEnv = environ;
        this.netPtr = l;
        NETICA.SetJavaApiNet_bn(l, this);
        this.addListener(this);
        environ.testForError();
        Util.log("NETICA: created Net: " + this.getName());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, NeticaException {
        this.user().setString("netConstructorClass4353115", constructorClass);
        this.user().setObject("netObjectCount4353115", new Integer(objectCount));
        Streamer streamer = new Streamer(objectOutputStream, this.getFileName(), this.parentEnv);
        this.write(streamer);
        streamer.flush();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NeticaException {
        Streamer streamer = new Streamer(objectInputStream, "temp.neta", this.parentEnv);
        Net net = new Net(streamer);
        streamer.flush();
        streamer.close();
        this.netPtr = net.getNetPtr();
        objectCount = (Integer)net.user().getObject("netObjectCount4353115");
        constructorClass = net.user().getString("netConstructorClass4353115");
        this.user().removeField("netConstructorClass4353115");
        this.user().removeField("netObjectCount4353115");
    }

    void onDeleteCallback(NeticaEvent neticaEvent) throws NeticaException {
        if (neticaEvent.getObject() != this) {
            Util.log(" *** WARNING *** NETICA_J. Net.onDeleteCallback().  Notified of event on object I'm not listening to:   event.id=" + neticaEvent.getKind() + "    Event was on object" + neticaEvent.getObject());
            return;
        }
        this.removeListener(this);
        Util.log(" *** INFO: Net set opaque ptr to 0;  was " + this.netPtr);
        if (Util.devel) {
            System.out.println(" *** NET:onDeleteCallback SUCCESS!!");
        }
        this.netPtr = 0L;
    }

    static Net getNetFromPtr(long l, Environ environ) throws NeticaException {
        Net net = null;
        try {
            net = NETICA.GetJavaApiNet_bn(l);
            environ.testForError();
        }
        catch (NeticaException neticaException) {
            return null;
        }
        if (net == null) {
            try {
                Class<?> clazz = Class.forName(Net.getConstructorClass());
                net = (Net)clazz.newInstance();
                Util.log("constructed new net from ptr.");
            }
            catch (Exception exception) {
                throw new NeticaException(6000, "Internal error during Net constuction: Invalid Class:" + exception.getMessage());
            }
            net.hookupToNative(l, environ);
        } else {
            Util.log("**** SUCCESSFULLY reusing a Net, YIPPEE!!!");
        }
        return net;
    }

    void assertNetIsViable() throws NeticaException {
        if (this.parentEnv == null || this.parentEnv.envPtr == 0L) {
            throw new NeticaException(6005, "The Environ associated with this object has been closed and so this object should no longer be used.");
        }
        if (this.netPtr == 0L) {
            throw new NeticaException(6005, "Native net object no longer exists, so this Net should no longer be used.");
        }
    }

    long getNetPtr() throws NeticaException {
        this.assertNetIsViable();
        return this.netPtr;
    }

    public void absorbNodes(NodeList nodeList) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        NETICA.AbsorbNodes_bn(l);
        nodeList.clear();
        this.parentEnv.testForError();
    }

    public void absorb(NodeList nodeList) throws NeticaException {
        this.absorbNodes(nodeList);
    }

    public void compile() throws NeticaException {
        NETICA.CompileNet_bn(this.netPtr);
        this.parentEnv.testForError();
        Util.log("NETICA: compiled Net: " + this.getName());
    }

    public NodeList copyNodes(NodeList nodeList) throws NeticaException {
        if (nodeList == null) {
            throw new NeticaException("nodeList is null; cannot duplicate nodes.");
        }
        long l = NETICA.CopyNodes_bn(nodeList.getNodeListPtr(), this.netPtr, null);
        this.parentEnv.testForError();
        NodeList nodeList2 = new NodeList(l, this);
        return nodeList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws NeticaException {
        if (this.netPtr == 0L) {
            throw new NeticaException(6005, "Net.delete(): Native net was already deleted.");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String string = this.getName();
            NETICA.DeleteNet_bn(this.netPtr);
            this.parentEnv.testForError();
            Util.log("NETICA: deleted Net: " + string);
        }
    }

    public int generateRandomCase(NodeList nodeList, int n, double d) throws NeticaException {
        if (nodeList == null) {
            nodeList = this.getNodes();
        }
        long l = nodeList.getNodeListPtr();
        int n2 = NETICA.GenerateRandomCase_bn(l, n, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
        return n2;
    }

    public static synchronized Vector getAllNets(Environ environ) throws NeticaException {
        Vector<Net> vector = new Vector<Net>();
        int n = 0;
        while (true) {
            long l = NETICA.GetNthNet_bn(n++, environ.envPtr);
            environ.testForError();
            if (l == 0L) break;
            vector.add(Net.getNetFromPtr(l, environ));
        }
        return vector;
    }

    public String getAllNodesets(boolean bl) throws NeticaException {
        String string = NETICA.GetAllNodesets_bn(this.netPtr, bl, 0L);
        this.parentEnv.testForError();
        return string;
    }

    public int getAutoUpdate() throws NeticaException {
        int n = NETICA.GetNetAutoUpdate_bn(this.netPtr);
        this.parentEnv.testForError();
        return n;
    }

    public static String getConstructorClass() {
        return constructorClass;
    }

    public NodeList getElimOrder() throws NeticaException {
        long l = NETICA.GetNetElimOrder_bn(this.netPtr);
        this.parentEnv.testForError();
        if (l == 0L) {
            return null;
        }
        return new NodeList(l, this);
    }

    public String getFileName() throws NeticaException {
        String string = NETICA.GetNetFileName_bn(this.netPtr);
        this.parentEnv.testForError();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public double getFindingsProbability() throws NeticaException {
        double d = NETICA.FindingsProbability_bn(this.netPtr);
        this.parentEnv.testForError();
        return d;
    }

    public double getJointProbability(NodeList nodeList, int[] nArray) throws NeticaException {
        long l = nodeList.getNodeListPtr();
        double d = NETICA.JointProbability_bn(l, nArray);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
        return d;
    }

    public int[] getMostProbableConfig(NodeList nodeList) throws NeticaException {
        int[] nArray = new int[nodeList.size()];
        long l = nodeList.getNodeListPtr();
        NETICA.MostProbableConfig_bn(l, nArray, 0);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
        return nArray;
    }

    public Node getNode(String string) throws NeticaException {
        long l = NETICA.NodeNamed_bn(string, this.netPtr);
        this.parentEnv.testForError();
        if (l == 0L) {
            return null;
        }
        Node node = Node.getNodeFromPtr(l, this);
        this.parentEnv.testForError();
        return node;
    }

    public NodeList getNodes() throws NeticaException {
        long l = NETICA.GetNetNodes_bn(this.netPtr);
        this.parentEnv.testForError();
        return new NodeList(l, this);
    }

    public Color getNodesetColor(String string) throws NeticaException {
        int n = NETICA.SetNodesetColor_bn(string, -1, this.netPtr, 0L);
        this.parentEnv.testForError();
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return new Color(n2, n3, n4);
    }

    public void getRelatedNodes(NodeList nodeList, String string, NodeList nodeList2) throws NeticaException {
        long l = nodeList2.getNodeListPtr(this);
        this.parentEnv.testForError();
        long l2 = nodeList.getNodeListPtr();
        NETICA.GetRelatedNodesMult_bn(l2, string, l);
        this.parentEnv.testForError();
        NodeList nodeList3 = new NodeList(l2, this);
        this.parentEnv.testForError();
        nodeList.removeAllElements();
        nodeList.addAll(nodeList3);
    }

    public void readFindings(long[] lArray, Streamer streamer, NodeList nodeList, long[] lArray2, double[] dArray) throws NeticaException {
        if (nodeList == null) {
            nodeList = this.getNodes();
        }
        long l = nodeList.getNodeListPtr();
        NETICA.ReadNetFindings2_bn(lArray, streamer.streamPtr, l, false, lArray2, dArray);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public void readFindings(long[] lArray, Streamer streamer, boolean bl, NodeList nodeList, long[] lArray2, double[] dArray) throws NeticaException {
        if (nodeList == null) {
            nodeList = this.getNodes();
        }
        long l = nodeList.getNodeListPtr();
        NETICA.ReadNetFindings2_bn(lArray, streamer.streamPtr, l, bl, lArray2, dArray);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public int redoOperation(double d) throws NeticaException {
        int n = NETICA.RedoNetOper_bn(this.netPtr, d);
        this.parentEnv.testForError();
        return n;
    }

    public void reorderNodesets(String string) throws NeticaException {
        NETICA.ReorderNodesets_bn(this.netPtr, string, 0L);
        this.parentEnv.testForError();
    }

    public void setNodesetColor(String string, Color color) throws NeticaException {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = n << 16 | n2 << 8 | n3;
        NETICA.SetNodesetColor_bn(string, n4, this.netPtr, 0L);
        this.parentEnv.testForError();
    }

    public String reportJunctionTree() throws NeticaException {
        String string = NETICA.ReportJunctionTree_bn(this.netPtr);
        this.parentEnv.testForError();
        return string;
    }

    public void retractFindings() throws NeticaException {
        NETICA.RetractNetFindings_bn(this.netPtr);
        this.parentEnv.testForError();
    }

    void reviseCPTsByCaseFile(InputStream inputStream, String string, NodeList nodeList, double d) throws NeticaException {
        Streamer streamer = new Streamer(inputStream, string, this.parentEnv);
        this.reviseCPTsByCaseFile(streamer, nodeList, d);
        streamer.finalize();
    }

    public void reviseCPTsByCaseFile(Streamer streamer, NodeList nodeList, double d) throws NeticaException {
        if (nodeList == null) {
            nodeList = this.getNodes();
        }
        long l = nodeList.getNodeListPtr();
        NETICA.ReviseCPTsByCaseFile_bn(streamer.streamPtr, l, 0, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public void reviseCPTsByFindings(NodeList nodeList, double d) throws NeticaException {
        if (nodeList == null) {
            nodeList = this.getNodes();
        }
        long l = nodeList.getNodeListPtr();
        NETICA.ReviseCPTsByFindings_bn(l, 0, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l);
        this.parentEnv.testForError();
    }

    public void setAutoUpdate(int n) throws NeticaException {
        NETICA.SetNetAutoUpdate_bn(this.netPtr, n);
        this.parentEnv.testForError();
    }

    public static void setConstructorClass(String string) throws NeticaException {
        Class<?> clazz;
        Class<?> clazz2;
        Object var1_1 = null;
        try {
            clazz2 = Class.forName(string);
            clazz = Class.forName("norsys.netica.Net");
        }
        catch (Exception exception) {
            throw new NeticaException(6001, "The class " + string + " could not be found on the classpath.");
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new NeticaException(6002, string + " is not an extension of norsys.netica.Net");
        }
        constructorClass = string;
    }

    public void setElimOrder(NodeList nodeList) throws NeticaException {
        if (nodeList == null) {
            NETICA.SetNetElimOrder_bn(this.netPtr, 0L);
        } else {
            long l = nodeList.getNodeListPtr();
            NETICA.SetNetElimOrder_bn(this.netPtr, l);
            this.parentEnv.testForError();
            NETICA.DeleteNodeList_bn(l);
        }
        this.parentEnv.testForError();
    }

    public double sizeCompiled() throws NeticaException {
        double d = NETICA.SizeCompiledNet_bn(this.netPtr, 0);
        this.parentEnv.testForError();
        return d;
    }

    public void uncompile() throws NeticaException {
        NETICA.UncompileNet_bn(this.netPtr);
        this.parentEnv.testForError();
        Util.log("NETICA: uncompiled Net: " + this.getName());
    }

    public int undoLastOperation(double d) throws NeticaException {
        int n = NETICA.UndoNetLastOper_bn(this.netPtr, d);
        this.parentEnv.testForError();
        return n;
    }

    public void write(Streamer streamer) throws NeticaException {
        NETICA.WriteNet_bn(this.netPtr, streamer.streamPtr);
        this.parentEnv.testForError();
        if (streamer.outputStream != null) {
            byte[] byArray = NETICA.GetStreamContents_ns(streamer.streamPtr);
            this.parentEnv.testForError();
            try {
                streamer.outputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new NeticaException("Streamer(OutputStream, Environ): IOException writing OutputStream");
            }
        }
    }

    public long writeFindings(Streamer streamer, NodeList nodeList, long l, double d) throws NeticaException {
        if (nodeList == null) {
            nodeList = this.getNodes();
        }
        long l2 = nodeList.getNodeListPtr();
        long l3 = NETICA.WriteNetFindings_bn(l2, streamer.streamPtr, l, d);
        this.parentEnv.testForError();
        NETICA.DeleteNodeList_bn(l2);
        this.parentEnv.testForError();
        return l3;
    }

    public String createCustomReport(NodeList nodeList, String string, String string2) throws NeticaException {
        long l = nodeList == null ? 0L : nodeList.getNodeListPtr();
        String string3 = NETICA.CreateCustomReport_bn(this.netPtr, l, string, string2);
        this.parentEnv.testForError();
        return string3;
    }

    public void delete() throws NeticaException {
        this.finalize();
    }

    public NodeList duplicateNodes(NodeList nodeList) throws NeticaException {
        return this.copyNodes(nodeList);
    }

    public void readCase(long[] lArray, Streamer streamer, NodeList nodeList, long[] lArray2, double[] dArray) throws NeticaException {
        this.readFindings(lArray, streamer, nodeList, lArray2, dArray);
    }

    public long writeCase(NodeList nodeList, Streamer streamer, long l, double d) throws NeticaException {
        return this.writeFindings(streamer, nodeList, l, d);
    }
}

