/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import norsys.netica.NeticaException;
import norsys.netica.Node;
import norsys.netica.State;
import norsys.netica.gui.DataDisplayer;
import norsys.netica.gui.NodePanel;
import norsys.netica.gui.NodePanel_BeliefBars;

public class NodePanel_BeliefBarsRow
extends JPanel
implements DataDisplayer {
    public static Color defaultForegroundColor = NodePanel_BeliefBars.defaultForegroundColor;
    public static Font defaultFont = new Font("SansSerif", 1, 12);
    public static Border defaultTextBorder = BorderFactory.createEmptyBorder(0, 8, 0, 8);
    public JLabel stateNameLabel;
    public JLabel stateValueLabel;
    BBArea bbArea;
    NodePanel_BeliefBars parentBB;
    State state;

    public NodePanel_BeliefBarsRow(NodePanel_BeliefBars nodePanel_BeliefBars, State state) throws NeticaException {
        try {
            Node node = state.getNode();
            this.parentBB = nodePanel_BeliefBars;
            this.state = state;
            this.setLayout(new BorderLayout());
            this.setBackground(nodePanel_BeliefBars.getBackground());
            this.stateNameLabel = new JLabel("", 2);
            this.stateNameLabel.setBorder(defaultTextBorder);
            this.stateNameLabel.setFont(defaultFont);
            this.stateNameLabel.setBackground(null);
            this.stateNameLabel.setForeground(null);
            this.add((Component)this.stateNameLabel, "West");
            this.stateValueLabel = new JLabel("", 4);
            this.stateValueLabel.setBorder(defaultTextBorder);
            this.stateValueLabel.setFont(defaultFont);
            this.stateValueLabel.setBackground(null);
            this.stateValueLabel.setForeground(null);
            this.add((Component)this.stateValueLabel, "Center");
            this.bbArea = new BBArea(nodePanel_BeliefBars.bbBarsAreaWidth + 1, nodePanel_BeliefBars.bbItemHeight, 0, nodePanel_BeliefBars.bbBarHeight);
            this.bbArea.setBackground(nodePanel_BeliefBars.bbBarsAreaColor);
            this.bbArea.setForeground(null);
            this.add((Component)this.bbArea, "East");
            this.refreshDataDisplayed();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSize(this.getPreferredSize());
        this.refreshDataDisplayed();
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void refreshDataDisplayed() throws NeticaException {
        String string = this.state.getTitle();
        if (string.length() == 0) {
            string = this.state.getName();
        }
        this.stateNameLabel.setText(string);
        if (this.parentBB.floats != null) {
            this.setForeground(Color.black);
            if (this.parentBB.nodeKind == 201) {
                this.stateValueLabel.setText(NodePanel.prob2String(this.parentBB.floats[this.state.getIndex()], NodePanel.probabilitiesFormat));
            } else {
                this.stateValueLabel.setText(NodePanel.sigDigits(this.parentBB.floats[this.state.getIndex()], 2, true));
            }
            this.bbArea.barLng = Math.round((float)(this.parentBB.bbBarsAreaWidth + 1) * this.parentBB.norm_floats[this.state.getIndex()]);
            this.bbArea.setVisible(true);
        } else {
            this.stateValueLabel.setText("    ");
            this.setForeground(Color.gray);
            this.bbArea.setVisible(false);
            if (this.state.getNode().finding().getState() == this.state.getIndex()) {
                this.bbArea.barLng = this.parentBB.bbBarsAreaWidth + 1;
                this.bbArea.setVisible(true);
            }
        }
        this.repaint();
    }

    JPanel getBeliefBars() {
        return this.bbArea;
    }

    class BBArea
    extends JPanel {
        int barLng;
        int barHgt;
        int w;
        int h;

        BBArea(int n, int n2, int n3, int n4) {
            this.barLng = n3;
            this.barHgt = n4;
            this.w = n;
            this.h = n2;
            this.setBackground(NodePanel_BeliefBarsRow.this.parentBB.bbBarsColor);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.w, this.h);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(this.getForeground());
            graphics.fillRect(1, (this.getHeight() - this.barHgt) / 2, this.barLng, this.barHgt);
            graphics.drawLine(0, 0, 0, this.getHeight());
            int n = Math.round((float)this.getWidth() * 0.25f);
            NodePanel.drawDashedLine(graphics, n, 0, n, this.getHeight(), 1.0, 3.0);
            n = Math.round((float)this.getWidth() * 0.5f);
            NodePanel.drawDashedLine(graphics, n, 0, n, this.getHeight(), 1.0, 3.0);
            n = Math.round((float)this.getWidth() * 0.75f);
            NodePanel.drawDashedLine(graphics, n, 0, n, this.getHeight(), 1.0, 3.0);
        }
    }
}

