/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.io.PrintStream;
import java.util.Date;
import norsys.netica.NETICA;

public class Util {
    static boolean logging = false;
    static boolean devel = false;
    static PrintStream logStream = System.out;

    Util() {
    }

    static synchronized void enableLogging(boolean bl) {
        logging = bl;
        logStream.println("Logging is now " + (bl ? "enabled." : "disabled."));
    }

    public static boolean isAscii(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    static void log(String string) {
        if (logging) {
            StringBuffer stringBuffer = new StringBuffer(new Date().toString());
            stringBuffer.append(" : ");
            stringBuffer.append(string);
            logStream.println(stringBuffer);
        }
    }

    static synchronized void setLoggingDest(PrintStream printStream) {
        logStream.println("Logging being reassigned to " + printStream);
        logStream = printStream;
    }

    public static double[] toDoubles(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double)((long)((double)fArray[i] * 1.0E8)) / 1.0E8;
        }
        return dArray;
    }

    public static float[] toFloats(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    static boolean approxEquals(double d, double d2) {
        return Math.abs(d - d2) <= 1.0E-7;
    }

    static boolean approxEquals(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    static void test_mr() {
        NETICA.test_mr();
    }
}

