/*
 * Decompiled with CFR 0.152.
 */
package norsys.netica;

import java.util.Enumeration;
import java.util.Vector;
import norsys.netica.Learner;
import norsys.netica.NETICA;
import norsys.netica.NeticaException;
import norsys.netica.Streamer;
import norsys.netica.Util;

public class Environ {
    private static Environ defaultEnviron = null;
    Vector streamersOwned = new Vector();
    public static final int COMPLETE_CHECK = 4;
    public static final int NO_CHECK = 1;
    static final int QUERY_CHECK = -1;
    public static final int QUICK_CHECK = 2;
    public static final int REGULAR_CHECK = 3;
    public static double INFINITY = 0.0;
    public static double UNDEF_DBL = 0.0;
    static final char QUERY_CHAR_ns = '\uffff';
    long envPtr;
    static final int QUERY_ns = -1;
    private static final String NORMAL_MESSAGE = "A-Okay";
    private int result = 0;
    private String mesg = "A-Okay";

    public Environ(String string) throws NeticaException {
        if (defaultEnviron != null && Environ.defaultEnviron.envPtr != 0L) {
            throw new NeticaException("An environment already exists that has not been closed with Environ.finalize().  With the current version of Netica, only one Environment can be active at once.  Close the existing Environ before constructing another.");
        }
        this.envPtr = NETICA.NewNeticaEnviron_bn(string);
        defaultEnviron = this;
        this.init();
        if (this.getVersion() != 408) {
            throw new NeticaException("Incorrect Netica library version.  Your Netica.dll or Netica.so file is incorrect for this version of Netica-J.");
        }
        Util.log("NETICA: created Environ.");
    }

    Environ() {
    }

    String init() throws NeticaException {
        this.testForValidEnvironment();
        String[] stringArray = new String[1];
        this.result = NETICA.InitNetica_bn(this.envPtr, stringArray);
        this.mesg = new String(stringArray[0]);
        if (this.result < 0) {
            Util.log("Environ.init(): " + this.mesg);
            System.err.println("Environ.init(): " + this.mesg);
            throw new NeticaException(this.mesg);
        }
        INFINITY = NETICA.GetInfinityDbl_ns();
        UNDEF_DBL = NETICA.GetUndefDbl_ns();
        NETICA.SetLanguage_ns(this.envPtr, "Java");
        this.testForError();
        this.assertEnumeratedTypesMatch();
        return this.mesg;
    }

    void testForError() throws NeticaException {
        this.testForValidEnvironment();
        long l = NETICA.GetError_ns(this.envPtr, 5, 0L);
        if (l != 0L) {
            long l2;
            NeticaException neticaException = new NeticaException(this.envPtr, l);
            NETICA.ClearError_ns(l);
            NETICA.ClearErrors_ns(this.envPtr, 6);
            while ((l2 = NETICA.GetError_ns(this.envPtr, 6, 0L)) != 0L) {
                NETICA.ClearError_ns(l2);
            }
            throw neticaException;
        }
    }

    void clearErrors(int n) {
        if (this.envPtr == 0L) {
            return;
        }
        try {
            NETICA.ClearErrors_ns(this.envPtr, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void finalize() throws NeticaException {
        String[] stringArray;
        this.testForValidEnvironment();
        if (this.envPtr == 0L) {
            return;
        }
        Enumeration enumeration = this.streamersOwned.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (Streamer)enumeration.nextElement();
            stringArray.streamPtr = 0L;
            this.streamersOwned.remove(stringArray);
        }
        stringArray = new String[1];
        this.result = NETICA.CloseNetica_bn(this.envPtr, stringArray);
        this.envPtr = 0L;
    }

    public int getArgumentChecking() throws NeticaException {
        this.testForValidEnvironment();
        int n = NETICA.ArgumentChecking_ns(-1, this.envPtr);
        this.testForError();
        return n;
    }

    public char getCaseFileDelimChar() throws NeticaException {
        this.testForValidEnvironment();
        char c = NETICA.SetCaseFileDelimChar_ns('\uffff', this.envPtr);
        this.testForError();
        return c;
    }

    public static Environ getDefaultEnviron() {
        return defaultEnviron;
    }

    public double getMemoryUsageLimit() throws NeticaException {
        this.testForValidEnvironment();
        double d = NETICA.LimitMemoryUsage_ns(-1.0, this.envPtr);
        this.testForError();
        return d;
    }

    public char getMissingDataChar() throws NeticaException {
        this.testForValidEnvironment();
        char c = NETICA.SetMissingDataChar_ns('\uffff', this.envPtr);
        this.testForError();
        return c;
    }

    public int getVersion() throws NeticaException {
        this.testForValidEnvironment();
        String[] stringArray = new String[1];
        int n = NETICA.GetNeticaVersion_bn(this.envPtr, stringArray);
        this.testForError();
        return n;
    }

    public String getVersionString() throws NeticaException {
        this.testForValidEnvironment();
        String[] stringArray = new String[1];
        NETICA.GetNeticaVersion_bn(this.envPtr, stringArray);
        this.testForError();
        StringBuffer stringBuffer = new StringBuffer();
        String string = stringArray[0];
        int n = string.indexOf("4.08");
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append("4.08");
        int n2 = string.indexOf("Netica");
        stringBuffer.append(string.substring(n + 4, n2));
        stringBuffer.append("Netica-J");
        stringBuffer.append(string.substring(n2 + 6));
        return stringBuffer.toString();
    }

    public void setArgumentChecking(int n) throws NeticaException {
        this.testForValidEnvironment();
        NETICA.ArgumentChecking_ns(n, this.envPtr);
        this.testForError();
    }

    public void setCaseFileDelimChar(char c) throws NeticaException {
        this.testForValidEnvironment();
        NETICA.SetCaseFileDelimChar_ns(c, this.envPtr);
        this.testForError();
    }

    public void setMemoryUsageLimit(double d) throws NeticaException {
        this.testForValidEnvironment();
        NETICA.LimitMemoryUsage_ns(d, this.envPtr);
        this.testForError();
    }

    public void setMissingDataChar(char c) throws NeticaException {
        this.testForValidEnvironment();
        char c2 = NETICA.SetMissingDataChar_ns(c, this.envPtr);
        this.testForError();
    }

    public double getMaxMemoryUsage() throws NeticaException {
        return this.getMemoryUsageLimit();
    }

    public void setMaxMemoryUsage(double d) throws NeticaException {
        this.setMemoryUsageLimit(d);
    }

    private synchronized void testForValidEnvironment() throws NeticaException {
        if (this.envPtr == 0L) {
            throw new NeticaException(6005, "This environment has been closed down and can no longer be used.");
        }
    }

    private void assertEnumeratedTypesMatch() throws NeticaException {
        int n = NETICA.enumeratedTypesMatch_javaApi(40, INFINITY, UNDEF_DBL, -1, '\uffff', 184, 28, 3458, -180, -37, -461, 1655L, 1296, 2 * Learner.COUNTING_LEARNING + 3 * Learner.EM_LEARNING + 5 * Learner.GRADIENT_DESCENT_LEARNING);
        if (n != 0) {
            throw new NeticaException("JAVA-to-C Enumerated type mismatch (Code Block " + n + ").  Your Netica.dll or Netica.so file is incorrect for this version of Netica-J.");
        }
    }
}

